#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;

uniform mat4 MVP;
uniform float Time;
uniform vec2 Distort;
uniform vec2 DistortSpeed;


void main()
{
    vec4 vertex = vec4(vertexPosition_modelspace,1); // Transform an homogeneous 4D vector, remember ?

	vertex.x = vertex.x + cos(Time * DistortSpeed.y + vertex.y)*Distort.y;
	vertex.y = vertex.y + sin(Time * DistortSpeed.x + vertex.x)*Distort.x;

    gl_Position = MVP * vertex;
}